<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e(config('app.name', 'IMEI SaaS')); ?></title>

    <!-- Fonts -->
    <link rel="dns-prefetch" href="//fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=Nunito" rel="stylesheet">

    <!-- Assets -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/sass/app.scss', 'resources/js/app.js']); ?>
</head>
<body>
<div id="app">

    
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark shadow-sm">
        <div class="container">

            <a class="navbar-brand" href="<?php echo e(route('dashboard')); ?>">
                IMEI SaaS
            </a>

            <button class="navbar-toggler" type="button"
                    data-bs-toggle="collapse"
                    data-bs-target="#navbarSupportedContent">
                <span class="navbar-toggler-icon"></span>
            </button>

            <div class="collapse navbar-collapse" id="navbarSupportedContent">

                
                <ul class="navbar-nav me-auto">
                    <?php if(auth()->guard()->check()): ?>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo e(route('dashboard')); ?>">
                                Dashboard
                            </a>
                        </li>

                        <?php if(auth()->user()->role === 'admin'): ?>

                            <li class="nav-item">
                                <a class="nav-link" href="<?php echo e(url('/dealers')); ?>">
                                    Create Dealer
                                </a>
                            </li>

                            
                            <li class="nav-item">
                                <a class="nav-link" href="<?php echo e(url('/imports/inventory')); ?>">
                                    Upload Inventory File
                                </a>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link" href="<?php echo e(url('/imports/allocation')); ?>">
                                    Upload Sales to Dealer
                                </a>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link" href="<?php echo e(url('/imports/activation')); ?>">
                                    Upload Activation File
                                </a>
                            </li>
                        <?php endif; ?>

                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo e(route('reports.devices')); ?>">
                                Reports
                            </a>
                        </li>
                    <?php endif; ?>
                </ul>

                
                <ul class="navbar-nav ms-auto">
                    <?php if(auth()->guard()->guest()): ?>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo e(route('login')); ?>">
                                Login
                            </a>
                        </li>
                    <?php else: ?>
                        <li class="nav-item text-white mt-2 me-3">
                            <?php echo e(auth()->user()->email); ?>

                        </li>

                        <li class="nav-item">
                            <form method="POST" action="<?php echo e(route('logout')); ?>">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="btn btn-sm btn-outline-light">
                                    Logout
                                </button>
                            </form>
                        </li>
                    <?php endif; ?>
                </ul>

            </div>
        </div>
    </nav>

    
    <main class="py-4">
        <?php echo $__env->yieldContent('content'); ?>
    </main>

</div>


<?php echo $__env->yieldPushContent('scripts'); ?>

</body>
</html>
<?php /**PATH /Users/soumadeep/Desktop/imei-saas/resources/views/layouts/app.blade.php ENDPATH**/ ?>