<?php $__env->startSection('content'); ?>
<div class="container">
    <h2 class="mb-4">Device Report</h2>

    
    <form method="GET" class="row g-3 mb-4 align-items-end">

        
        <div class="col-md-3">
            <label class="form-label">Status</label>
            <select name="status" class="form-control">
                <option value="">All Status</option>
                <option value="in_stock" <?php if(request('status')=='in_stock'): echo 'selected'; endif; ?>>
                    In Stock
                </option>
                <option value="allocated" <?php if(request('status')=='allocated'): echo 'selected'; endif; ?>>
                    Allocated
                </option>
                <option value="activated" <?php if(request('status')=='activated'): echo 'selected'; endif; ?>>
                    Activated
                </option>
            </select>
        </div>

        
        <div class="col-md-3">
            <label class="form-label">Model</label>
            <input type="text"
                   name="model"
                   class="form-control"
                   placeholder="Model"
                   value="<?php echo e(request('model')); ?>">
        </div>

        
        <?php if(auth()->user()->role === 'admin'): ?>
            <div class="col-md-3">
                <label class="form-label">Dealer</label>
                <select name="dealer_id" class="form-control">
                    <option value="">All Dealers</option>
                    <?php $__currentLoopData = $dealers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dealer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($dealer->id); ?>"
                            <?php if(request('dealer_id') == $dealer->id): echo 'selected'; endif; ?>>
                            <?php echo e($dealer->name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
        <?php endif; ?>

        
        <div class="col-md-2">
            <button type="submit" class="btn btn-primary w-100">
                Filter
            </button>
        </div>

        
        <div class="col-md-2">
            <a href="<?php echo e(route('reports.devices.export', request()->query())); ?>"
               class="btn btn-success w-100">
                Export Excel
            </a>
        </div>

    </form>

    
    <table class="table table-bordered table-striped">
        <thead>
            <tr>
                <th>Model</th>
                <th>IMEI 1</th>
                <th>IMEI 2</th>
                <th>Dealer</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
        <?php $__empty_1 = true; $__currentLoopData = $devices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $device): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <tr>
                <td><?php echo e($device->model); ?></td>
                <td><?php echo e($device->masked_imei_1); ?></td>
                <td><?php echo e($device->masked_imei_2); ?></td>
                <td><?php echo e($device->allocation?->dealer?->name ?? '-'); ?></td>
                <td><?php echo e(ucfirst($device->status)); ?></td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <tr>
                <td colspan="5" class="text-center">
                    No records found
                </td>
            </tr>
        <?php endif; ?>
        </tbody>
    </table>

    
    <div class="mt-3">
        <?php echo e($devices->links()); ?>

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\imei-saas\resources\views/reports/devices.blade.php ENDPATH**/ ?>